VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CGILibGlobal"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'Error logging class to log events
Private m_Log As CEventLog

Public Property Get CGILibGlobal() As CGILibGlobal
    Set CGILibGlobal = Me
End Property

Public Sub Run(CGIApp As ICGIApp, sAppPath As String, _
               sAppName As String, lAppThread As Long)
    
    Dim CGI As CCGI
    Dim sLogFile As String
    
    On Error GoTo LogCreateError
    
    'Create the event log. Use the app name to name the file
    Set m_Log = New CEventLog
    sLogFile = sAppPath & "\" & sAppName & ".log"
    m_Log.Create sLogFile, sAppName, lAppThread
    
    On Error GoTo GlobalHandler
    
    'Log initial info
    LogAppInfo sAppPath, sAppName, lAppThread
    
    'Create the CGI object and log all the info
    Set CGI = New CCGI
    LogCGIInfo CGI
    
    'Now run the client's CGI application
    CGIMain CGIApp, CGI
    
    m_Log.WriteEntry "CGI App " & sAppName & " Terminating: ErrCode = 0"
    Exit Sub
LogCreateError:
    'Errors occured while creating the log, so log to NT Event Log.
    'Assert condition if in debug mode
    Debug.Assert False
    
    Dim sErr As String
    sErr = "A fatal error has occured in the CGI Application before" _
         & " the event log, " & sLogFile & ", could be created." _
         & vbCrLf & "CGI Error: " & BasicError(Err.Number) _
         & " = " & Err.Description
         
    App.LogEvent sErr, vbLogEventTypeError

    Exit Sub
GlobalHandler:
    Dim sErrMsg As String, lErrNum As Long, sErrSrc As String
    Dim sLogMsg As String
    sErrMsg = Err.Description
    lErrNum = BasicError(Err.Number)
    sErrSrc = Err.Source
    
    With m_Log
        .NewEntry
        .WriteLn "Error Number: " & lErrNum
        .WriteLn "Description : " & sErrMsg
        .WriteLn "Source      : " & sErrSrc
        .CloseEntry
    End With
    
    m_Log.WriteEntry "CGI App " & sAppName & " Terminating: ErrCode = " & lErrNum
    Exit Sub
End Sub

Private Sub CGIMain(CGIApp As ICGIApp, CGI As CCGI)
    With CGIApp
        'Create the CGI Application class
        .Create CGI, m_Log
        
        'Now process the CGI Request.
        .PreProcess
        .Process
        .PostProcess
    End With
End Sub

'****************************************************************
'Helper function which converts a dictionary to a nicely
'formatted string.
'****************************************************************
Private Function DictionaryToString(Dict As Dictionary) As String
    Dim sResult As String
    Dim vKey As Variant
    For Each vKey In Dict
        sResult = sResult & vKey & " = " & Dict(vKey) & vbCrLf
    Next vKey
    DictionaryToString = sResult
End Function

'****************************************************************
'Logs all the CGI information.
'****************************************************************
Private Sub LogCGIInfo(CGI As CCGI)
    With m_Log
        .NewEntry
        .WriteLn "Query String Parameters:" & vbCrLf & "-------------------------"
        .WriteLn "Query String: " & CGI.QueryString
        .WriteLn DictionaryToString(CGI.Params)
        .WriteLn "Environmental Variables:" & vbCrLf & "-------------------------"
        .WriteLn DictionaryToString(CGI.Environs)
        .CloseEntry
    End With
End Sub

'****************************************************************
'Logs all application information
'****************************************************************
Private Sub LogAppInfo(sAppPath As String, sAppName As String, lAppThread As Long)
    With m_Log
        .NewEntry
        .WriteLn "CGI Application Startup Details:"
        .WriteLn "---------------------------------------"
        .WriteLn "Executable: " & sAppPath & "\" & sAppName
        .WriteLn "Thread ID:" & lAppThread
        .CloseEntry
    End With
End Sub

'****************************************************************
'Reformats the Error code to make it more presentable
'****************************************************************
Private Function BasicError(lErrNum As Long)
    BasicError = lErrNum And &HFFFF&
End Function

